#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Evolving Gyroid - studyMod01.fsh by  MacSlow
//https://www.shadertoy.com/view/ssBGDG
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

////////////////////////////////////////////////////////////////////////////////
//
// Evolving gyroid-thing - study into what can be done with all the different
// parameters one can tweak in a gyroid-function.
//
// Copyright 2021 Mirco Müller
//
// Author(s):
//   Mirco "MacSlow" Müller <macslow@gmail.com>
//
// This program is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License version 3, as published
// by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranties of
// MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
// PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program.  If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////

// the HW_PERFORMANCE-check should take care of some optimization, if that does
// not help you can still force GROUND_WAVES to 0 and/or AA_SIZE to 1 manually
#if HW_PERFORMANCE==0
#define GROUND_WAVES 0
const int AA_SIZE = 1;
#else
#define GROUND_WAVES 1
const int AA_SIZE = 2;
#endif

const float PI = 3.14159265359;
const int MAX_ITER = 96;
const float STEP_BIAS = .5;
const float EPSILON = .0001;
const float MAX_DIST = 12.;

float smin (float a, float b, float k)
{
    float h = clamp (.5 + .5*(b - a)/k, .0, 1.);
    return mix (b, a, h) - h*k*(1. - h); 
}

mat2 r2d (float deg)
{
    float rad = radians (deg);
    float c = cos (rad);
    float s = sin (rad);
    return mat2 (c, s, -s, c);
}

// using a slightly adapted implementation of iq's simplex noise from
// https://www.shadertoy.com/view/Msf3WH with hash(), noise() and fbm()
vec2 hash (in vec2 p)
{
    p = vec2 (dot (p, vec2 (127.1, 311.7)),
              dot (p, vec2 (269.5, 183.3)));

    return -1. + 2.*fract (sin (p)*43758.5453123);
}

float noise (in vec2 p)
{
    const float K1 = .366025404;
    const float K2 = .211324865;

    vec2 i = floor (p + (p.x + p.y)*K1);
    
    vec2 a = p - i + (i.x + i.y)*K2;
    vec2 o = step (a.yx, a.xy);    
    vec2 b = a - o + K2; 
    vec2 c = a - 1. + 2.*K2;

    vec3 h = max (.5 - vec3 (dot (a, a), dot (b, b), dot (c, c) ), .0);

    vec3 n = h*h*h*h*vec3 (dot (a, hash (i + .0)),
                           dot (b, hash (i + o)),
                           dot (c, hash (i + 1.)));

    return dot (n, vec3 (70.));
}

float fbm (in vec2 p, in int iters)
{
    mat2 rot = r2d (35.);
    float d = .0;
    float f = 1.;
    float fsum = .0;

    for (int i = 0; i < iters; ++i) {
        d += f*noise (p);
        fsum += f;
        f *= .5;
    }
    d /= fsum;

    return d;
}

float plane (vec3 p, float h)
{
    return p.y + h;
}

float ball (vec3 p, float r)
{
    return length (p) - r;
}

float cube (vec3 p, float size)
{
    return length (max (abs (p) - size, .0));
}

float gyroid (vec3 p, float scale, float thickness, float bias, vec2 modulation, vec2 offset)
{
    float modulate = (modulation.x > modulation.y) ? modulation.x : modulation.y;
    p *= scale;
    float d = dot (sin(p*modulation.x) + offset.x,
                   cos(p.yzx*modulation.x) + offset.y) - bias;

    return abs (d)/scale/modulate - thickness;
}

float scene (vec3 p)
{
    // doing the wavy ground with fbm() is a bit on the costly side
    vec3 groundP = p;
    groundP.x += iTime;
    float pk = 1.5;
    #if GROUND_WAVES 
    if( p.y<0.5 )
    pk += .25*fbm(groundP.xz, 2);
    #endif
    float ground = plane (p, pk);

    if (length(p) - 1.1 < ground) {
        p.xz *= r2d (5.*iTime);
        p.yx *= r2d (7.*iTime);
        vec2 modulation = vec2 (2. + .75*cos(iTime),
                                1.23 + .55*sin(iTime));
        float thickness = .125 *(1./(1. + 5.*( cos(iTime)*.5 + .5 )));
        float bias1 = 1.3;
        float bias2 = .3;
        float scale = 5.;
        vec2 offset = vec2 (.1, .4);
        float gyroid1 = gyroid (p, scale, thickness, bias1, modulation, offset)*.55;
        float gyroid2 = gyroid (p, scale, thickness, bias2, modulation, offset)*.55;
        float gyroidFinal = min (gyroid1 , gyroid2);
        gyroidFinal = gyroid1 + gyroid2*.1;

        float r = 1.125 + .05*cos (20.*p.y + 5.*iTime);
        float ball = ball (p, r);

        float g = smin (ball, gyroidFinal, -.05);
        ground = min (g, ground);
    }

    return ground;
}

float raymarch (vec3 ro, vec3 rd, out int iter)
{
    float d = .0;
    float t = .0;
    int i = 0;
    vec3 p = vec3 (.0);

    for (; i < MAX_ITER; ++i) {
        p = ro + d*rd;
        t = scene (p);
        if (abs (t) < EPSILON*(1. - .125*t) || d > MAX_DIST) {
            iter = i;
            break;
        }
        d += t*STEP_BIAS;
    }

    return d;
}

vec3 normal (vec3 p)
{
    vec2 e = vec2 (EPSILON, .0);
    float d = scene (p);
    vec3 n = normalize (vec3 (scene (p + e.xyy),
                              scene (p + e.yxy),
                              scene (p + e.yyx)) - d);
    return n;
}

float shadow (vec3 p, vec3 n, vec3 lPos, vec3 lDir)
{
    int ignore = 0;
    float distToWorld = raymarch (p + .01*n, lDir, ignore);
    float distToLight = distance (p, lPos);

    return distToWorld < distToLight ? .3 : 1.;
}

float ao (vec3 p, vec3 n, float stepSize, int iterations, float intensity)
{
  float ao = .0; 
  float dist = .0; 

  for (int a = 1; a <= iterations; ++a) {
    dist = float (a)*stepSize;
    ao += max (.0, (dist - scene (p + n*dist))/dist);
  }

  return 1. - ao*intensity;
}

vec3 shade (vec3 ro, vec3 rd, float d, vec3 n)
{
    vec3 p = ro + d*rd;

    vec3 lPos1 = vec3 (3.*cos(iTime), 3., 3.*sin(.4*iTime));
    vec3 lDir1 = normalize (lPos1 - p);
    float lDist1 = distance (lPos1, p);
    float attn1 = 30. / (lDist1*lDist1);
    vec3 lColor1 = vec3 (1., .9, .3);

    vec3 lPos2 = vec3 (-2.*cos(.3*iTime), 3., 4.*sin(iTime));
    vec3 lDir2 = normalize (lPos2 - p);
    float lDist2 = distance (lPos2, p);
    float attn2 = 40. / (lDist2*lDist2);
    vec3 lColor2 = vec3 (.2, .4, 1.);

    vec3 amb = vec3 (.1); 
    float diff1 = max (dot (n, lDir1), .0);
    float diff2 = max (dot (n, lDir2), .0);
    vec3 h1 = normalize (lDir1 - rd);
    vec3 h2 = normalize (lDir2 - rd);
    float spec1 = pow (max (dot (h1, n), .0), 40.);
    float spec2 = pow (max (dot (h2, n), .0), 40.);

    float s1 = shadow (p, n, lPos1, lDir1);
    float s2 = shadow (p, n, lPos2, lDir2);

    float ao = ao (p, n, .05, 12, .1);

    // don't do material assignment like this, this is a super lazy-ass hack!
    vec3 gyroidMaterial = 1.5*vec3(.9, .6, .4);
    bool isFloor = (p.y < -1.);
    float phase = cos (20.*(p.x + iTime));
    float mask = smoothstep (.005*d, .0025*d, .5 + .5*phase);
    vec3 floorMaterial = 1.5*mix (vec3(.9), vec3 (.1), mask);
    vec3 diffMaterial = isFloor ? floorMaterial : gyroidMaterial;

    return amb + ao*(attn1*s1*(diff1*diffMaterial*lColor1 + spec1) +
                     attn2*s2*(diff2*diffMaterial*lColor2 + spec2));
}

vec3 camera (vec2 uv, vec3 ro, vec3 aim, float zoom)
{
    vec3 camForward = normalize (aim - ro);
    vec3 worldUp = vec3 (.0, 1., .0);
    vec3 camRight = normalize (cross (camForward, worldUp));
    vec3 camUp = normalize (cross (camRight, camForward));
    vec3 camCenter = normalize (ro + camForward*zoom);

    return normalize (camCenter + uv.x*camRight + uv.y*camUp - ro);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // normalize and aspect-correct UVs
    vec2 uv = 2.*(fragCoord/iResolution.xy) - 1.;
    uv.x *= iResolution.x/iResolution.y;

    // allow some yaw-orbit with the mouse
    vec2 yaw = .75*vec2 (PI*cos (4.*iMouse.x/iResolution.x),
                         PI*sin (4.*iMouse.x/iResolution.x));
    float pitch = 1.;

    // create origin/camera/view-ray
    vec3 ro = vec3 (yaw.x, pitch, yaw.y);
    vec3 aim = vec3 (.0, .0, .0);
    float zoom = 1.75;
    vec3 rd = camera (uv, ro, aim, zoom);

    // raymarch, shading & floor-glow
    int iter = 0;
    float d = .0;
    vec3 p = vec3 (.0);
    vec3 n = vec3 (.0);
    vec3 color = vec3 (.0);
    float fog = .0;

    for (int x = 0; x < AA_SIZE; ++x) {
        for (int y = 0; y < AA_SIZE; ++y) {

			// anti-alias offset
			vec2 pixelOffset = vec2 (float (x), float (y))/float (AA_SIZE);

			// normalize and aspect-correct UVs
            uv = 2.*((fragCoord + pixelOffset)/iResolution.xy) - 1.;
            uv.x *= iResolution.x/iResolution.y;

    		// create viewray
    		rd = camera (uv, ro, aim, zoom);

			// primary/view ray
            //iter = 0;
			d = raymarch (ro, rd, iter);
            p = ro + d*rd;
            n = normal (p);
			vec3 ctmp = shade (ro, rd, d, n);
            /*if (p.y < -1.) {
                float glow = float (iter) / float (MAX_ITER);
                ctmp += pow (glow, 1.05)*vec3 (1., .8, .2);
            };*/
            fog = 1. / (1. + d*d*.1);
            ctmp *= fog;
            ctmp = mix (ctmp, .5*vec3 (.15, .4, .9), pow (1. - 1./d, 6.));

			color += ctmp;
        }
    }
    color /= float (AA_SIZE*AA_SIZE);

    // make the final picture 'pretty'
    color = color / (1. + color);
    color *= 1. - .25*dot (uv, uv);
    color = .2*color + .8*sqrt (color);

    fragColor = vec4(color, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

